unit Surface;
{Demonstrates some 3-D-features of MathImage.
 The routines marked by *********** use
 MathImage methods.}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Mathimge;

const tmin=-Pi; tmax=Pi; smin=0;
      smax=2*Pi;
      tmesh=90; smesh=10;

type
  TSurfaceForm = class(TForm)
    Panel1: TPanel;
    GraphButton: TButton;
    FillCheck: TCheckBox;
    WireButton: TButton;
    FillButton: TButton;
    UpButton: TButton;
    LeftButton: TButton;
    RightButton: TButton;
    DownButton: TButton;
    ColorDialog1: TColorDialog;
    InButton: TButton;
    OutButton: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    MoveInButton: TButton;
    MoveOutButton: TButton;
    graphimage: tMathImage;
    Button1: TButton;
    Panel2: TPanel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    vdshow: TLabel;
    vashow: TLabel;
    zrshow: TLabel;
    yrshow: TLabel;
    procedure WireButtonClick(Sender: TObject);
    procedure FillButtonClick(Sender: TObject);
    procedure GraphButtonClick(Sender: TObject);
    procedure InButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure InButtonMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure OutButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure OutButtonMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure UpButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure UpButtonMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure LeftButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RightButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DownButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormResize(Sender: TObject);
    procedure MoveOutButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MoveOutButtonMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MoveInButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MoveInButtonMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
  wirecolor,fillcolor:longint;
  canshow,zooming,rotating,MakeHide,first:boolean;
  function x0(t:extended):extended;
  function y0(t:extended):extended;
  function z0(t:extended):extended;
  function x1(t:extended):extended;
  function y1(t:extended):extended;
  function z1(t:extended):extended;
  function x2(t:extended):extended;
  function y2(t:extended):extended;
  function z2(t:extended):extended;
  procedure knot(t,s:extended; var x,y,z:extended);
  procedure dtknot(t,s:extended; var x,y,z:extended);
  procedure dsknot(t,s:extended; var x,y,z:extended);
  procedure normal(t,s:extended; var x,y,z:extended);
  procedure remakesurface;
  procedure redraw;
  procedure upd;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SurfaceForm: TSurfaceForm;

implementation

{$R *.DFM}

{*************************************}
procedure TSurfaceForm.FormCreate(Sender: TObject);
var i,j:integer; t,s,x,y,z:extended;
    created:boolean;
begin
  with graphimage do
  begin
    d3worldx1:=-6; d3worldx2:=6; d3worldy1:=-6;
    d3worldy2:=6; d3worldz1:=-3; d3worldz2:=3;
    d3zrotation:=45; d3yrotation:=35;
    d3viewdist:=6; d3viewangle:=6.4;
    wirecolor:=clnavy;
    fillcolor:=claqua;
    d3CreateSurfaceMem(tmesh,smesh,created);
    canshow:=created;
  end;
  makeHide:=false;
  first:=true;
  upd;
end;

procedure TSurfaceForm.WireButtonClick(Sender: TObject);
begin
  with colordialog1 do
  if execute then
  wirecolor:=color;
end;

procedure TSurfaceForm.FillButtonClick(Sender: TObject);
begin
  with colordialog1 do
  if execute then fillcolor:=color;
end;

function TSurfaceForm.x0; {Core Curve}
begin
  result:=2*cos(2*t)+cos(t);
end;

function TSurfaceForm.x1; {1st Derivative}
begin
  result:=-4*sin(2*t)-sin(t);
end;

function TSurfaceForm.x2;  {2nd Derivative}
begin
  result:=-8*cos(2*t)-cos(t);
end;

function TSurfaceForm.y0;  {Core Curve}
begin
  result:=2*sin(2*t)-sin(t);
end;

function TSurfaceForm.y1;
begin
  result:=4*cos(2*t)-cos(t);
end;

function TSurfaceForm.y2;
begin
  result:=-8*sin(2*t)+sin(t);
end;

function TSurfaceForm.z0;  {Core Curve}
begin
  result:=sin(3*t);
end;

function TSurfaceForm.z1;
begin
  result:=3*cos(3*t);
end;

function TSurfaceForm.z2;
begin
  result:=-9*sin(3*t);
end;

procedure TSurfaceForm.knot; {tube surface about core curve}
var u,v,x3,y3,z3,x4,y4,z4,x5,y5,z5,x6,y6,z6:extended;
begin
  u:=sqr(x1(t))+sqr(y1(t))+sqr(z1(t));
  v:=x1(t)*x2(t)+y1(t)*y2(t)+z1(t)*z2(t);
  x3:=x2(t)*u-x1(t)*v; {1st perp vector}
  y3:=y2(t)*u-y1(t)*v;
  z3:=z2(t)*u-z1(t)*v;
  x4:=y1(t)*z3-z1(t)*y3; {2nd perp vector}
  y4:=z1(t)*x3-x1(t)*z3;
  z4:=x1(t)*y3-y1(t)*x3;
  u:=sqrt(sqr(x3)+sqr(y3)+sqr(z3));
  v:=sqrt(sqr(x4)+sqr(y4)+sqr(z4));
  x5:=x3/u; y5:=y3/u; z5:=z3/u;  {1st normal}
  x6:=x4/v; y6:=y4/v; z6:=z4/v;   {2nd normal}
  x:=2*x0(t)+cos(s)*x5+sin(s)*x6; {Core curve + circle in normal plane}
  y:=2*y0(t)+cos(s)*y5+sin(s)*y6;
  z:=2*z0(t)+cos(s)*z5+sin(s)*z6;
end;

procedure TSurfaceForm.dtknot(t,s:extended; var x,y,z:extended);
var h,x1,x2,y1,y2,z1,z2:extended;
begin
  h:=1.0e-8;
  knot(t+h,s,x2,y2,z2);
  knot(t-h,s,x1,y1,z1);
  x:=(x2-x1)/h/2;
  y:=(y2-y1)/h/2;
  z:=(z2-z1)/h/2;
end;

procedure TSurfaceForm.dsknot(t,s:extended; var x,y,z:extended);
var h,x1,x2,y1,y2,z1,z2:extended;
begin
  h:=1.0e-8;
  knot(t,s+h,x2,y2,z2);
  knot(t,s-h,x1,y1,z1);
  x:=(x2-x1)/h/2;
  y:=(y2-y1)/h/2;
  z:=(z2-z1)/h/2;
end;

procedure TSurfaceForm.normal(t,s:extended; var x,y,z:extended);
var x1,x2,y1,y2,z1,z2,norm:extended;
begin
  dtknot(t,s,x1,y1,z1);
  dsknot(t,s,x2,y2,z2);
  x:=y1*z2-z1*y2;
  y:=z1*x2-z2*x1;
  z:=z1*y2-z2*y1;
  norm:=sqrt(sqr(x)+sqr(y)+sqr(z));
  x:=-x/norm; y:=-y/norm; z:=-z/norm;
end;

{**************************}
procedure TSurfaceForm.GraphButtonClick(Sender: TObject);
begin
  if canshow then
  begin
    screen.cursor:=crhourglass;
    if first then if fillcheck.checked then
    begin
      first:=false;
      makehide:=true;
    end;
    remakesurface;
    if canshow then redraw;
    screen.cursor:=crdefault;
  end;
end;

{************************************}
procedure TSurfaceForm.RemakeSurface;
var i,j:integer; t,s,x,y,z:extended; made:boolean;
begin
  for i:=0 to tmesh do
  begin
    t:=tmin+i*(tmax-tmin)/tmesh;
    for j:=0 to smesh do
    with graphimage do
    begin
      s:=smin+j*(smax-smin)/smesh;
      knot(t,s,x,y,z);
      d3makesurfacepoint(i,j,x,y,z,made);
      canshow:=canshow and made;
    end;
  end;
  if makehide then
  begin
    graphimage.d3MakeHideInfo(true);
    makehide:=false;
  end;
end;

{**************************************}
procedure TSurfaceForm.Redraw;
begin
  with graphimage do
  begin
    clear;
    d3drawworldbox;
    d3drawaxes('x','y','z');
    setcolor(wirecolor);
    canvas.brush.color:=fillcolor;
    if canshow then d3drawsurface(fillcheck.checked,true);
    canvas.brush.color:=clwhite;
    setcolor(clblack);
  end;
end;

{***********************************}
procedure TSurfaceForm.InButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  zooming:=true;
  while zooming do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3viewangle:=d3viewangle-0.1;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

{**********************************************}
procedure TSurfaceForm.InButtonMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  zooming:=false;
  first:=true;
end;

{etc, etc.................. much redundant code
using copy paste instead of brain}
procedure TSurfaceForm.OutButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  zooming:=true;
  while zooming do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3viewangle:=d3viewangle+0.1;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

procedure TSurfaceForm.OutButtonMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  zooming:=false;
  first:=true;
end;



procedure TSurfaceForm.UpButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  rotating:=true;
  while rotating do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3yrotation:=d3yrotation-0.5;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

procedure TSurfaceForm.UpButtonMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  rotating:=false;
  first:=true;
end;

procedure TSurfaceForm.LeftButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  rotating:=true;
  while rotating do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3zrotation:=d3zrotation-0.5;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

procedure TSurfaceForm.RightButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  rotating:=true;
  while rotating do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3zrotation:=d3zrotation+0.5;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;


procedure TSurfaceForm.DownButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  rotating:=true;
  while rotating do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3yrotation:=d3yrotation+0.5;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

{****************************}
procedure TSurfaceForm.FormResize(Sender: TObject);
begin
  graphimage.reset;
  graphbuttonclick(self);
end;

procedure TSurfaceForm.MoveOutButtonMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  zooming:=true;
  while zooming do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3viewdist:=d3viewdist+0.02;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

procedure TSurfaceForm.MoveOutButtonMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  zooming:=false;
end;

procedure TSurfaceForm.MoveInButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  zooming:=true;
  while zooming do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3viewdist:=d3viewdist-0.02;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

procedure TSurfaceForm.MoveInButtonMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  zooming:=false;
end;

{************** Cactus-(Normal)-Field}
procedure TSurfaceForm.Button1Click(Sender: TObject);
var savecolor:longint; i,j:integer;
    t,s,x1,y1,z1,x2,y2,z2:extended;
begin
  screen.cursor:=crhourglass;
  with GraphImage do
  begin
    savecolor:=canvas.pen.color;
    canvas.pen.color:=clred;
    for i:=0 to tmesh-1 do
    for j:=0 to smesh-1 do
    begin
      if d3visible(i,j) then
      begin
      t:=tmin+i*(tmax-tmin)/tmesh;
      s:=smin+j*(smax-smin)/smesh;
      knot(t,s,x1,y1,z1);
      normal(t,s,x2,y2,z2);
      d3drawline(x1,y1,z1,x1+x2,y1+y2,z1+z2);
      end;
    end;
    canvas.pen.color:=savecolor;
  end;
  screen.cursor:=crdefault;
end;



procedure tsurfaceform.upd;
begin
  with graphImage do
  begin
    vdshow.caption:=floattostrf(d3viewdist,ffgeneral,4,4);
    vashow.caption:=FloattoStrF(d3viewangle,ffgeneral,4,4);
    zrshow.caption:=FloattoStrF(d3zrotation,ffgeneral,4,4);
    yrshow.caption:=FloattoStrF(d3yrotation,ffgeneral,4,4);
  end;
end;


end.
